#ifndef __COMIDASCX_DLL_H_
#define __COMIDASCX_DLL_H_

#include "ComidasCommon.h"
#ifdef __cplusplus
extern "C"{
#endif

// Device ID definition //
#define COMI_ST101	0xD101
#define COMI_ST201	0xD201
#define COMI_ST202	0xD202
#define COMI_ST203	0xD203
#define COMI_ST301	0xD301
#define COMI_ST401	0xD401
#define COMI_ST402	0xD402
#define COMI_ST403	0xD403
#define COMI_ST501	0xD501
#define COMI_ST502	0xD502

#define COMI_CLX101	0xA101
#define COMI_CLX102	0xA102
#define COMI_CLX103	0xA103
#define COMI_CLX201	0xA201
#define COMI_CLX202	0xA202
#define COMI_CLX203	0xA203
#define COMI_CLX301	0xA301
#define COMI_CLX401	0xA401
#define COMI_CLX501	0xA501

#ifdef COMIDASLXDLL_EXPORTS
 #define COMIDAS_API __declspec(dllexport)
#else
 #ifdef _COMIDASLX_LOADER_C_
  #define EXTERN
 #else
  #define EXTERN extern
 #endif
 BOOL COMICX_LoadDll(void);
 void COMICX_UnloadDll(void);
 EXTERN HANDLE	(*COMICX_LoadDevice) (COMIDAS_DEVID deviceID, ULONG instance);
 EXTERN void	(*COMICX_UnloadDevice) (HANDLE hDevice);
 EXTERN void	(*COMICX_SetComiBus) (HANDLE hDevice, BOOL bEnable, BOOL bIsMaster);
 //___________ General A/D Functions _____________________________________________//
 EXTERN void	(*COMICX_AD_SetInputType) (HANDLE hDevice, int nInputMode);
 EXTERN BOOL	(*COMICX_AD_SetRange) (HANDLE hDevice, int ch, float vmin, float vmax);
 EXTERN int		(*COMICX_AD_GetDigit) (HANDLE hDevice, int ch);
 EXTERN float	(*COMICX_AD_GetVolt) (HANDLE hDevice, int ch);
 //___________ Unlimited A/D Scan for LX10x _____________________________________________//
 EXTERN long	(*COMICX_US1_Start) (HANDLE hDevice, int nNumChannel, int *pChanList,
			UINT dwScanFreq, UINT nBufSize, int nTrsMethod);
 EXTERN void	(*COMICX_US1_Stop) (HANDLE hDevice, BOOL bReleaseBuf);
 EXTERN long	(*COMICX_US1_ChangeScanFreq) (HANDLE hDevice, UINT dwScanFreq);
 EXTERN void	(*COMICX_US1_ResetCount) (HANDLE hDevice);
 EXTERN short*	(*COMICX_US1_GetBuffer) (HANDLE hDevice);
 EXTERN ULONG	(*COMICX_US1_CurCount) (HANDLE hDevice);
 EXTERN UINT	(*COMICX_US1_SBPos) (HANDLE hDevice, int chOrder, ULONG scanCount);
 EXTERN BOOL	(*COMICX_US1_ReleaseBuf) (HANDLE hDevice);
 EXTERN short	(*COMICX_US1_RetrvOne) (HANDLE hDevice, int chOrder, ULONG scanCount);
 EXTERN ULONG	(*COMICX_US1_RetrvChannel) (HANDLE hDevice, int chOrder, ULONG startCount, 
			int maxNumData, void *pDestBuf, TComiVarType VarType);
 EXTERN UINT	(*COMICX_US1_RetrvBlock) (HANDLE hDevice, UINT startCount, int maxNumScan, 
			void *pDestBuf, TComiVarType VarType);
 //___________ Unlimited A/D Scan for LX20x _____________________________________________//
 EXTERN void	(*COMICX_US2_SetTriggerEvent) (HANDLE hDevice, int nInputSource,
					int nEdgeType, int nTrgMode, float fAiRef, float fAiRefBand);
 EXTERN double	(*COMICX_US2_Start) (HANDLE hDevice, int nNumChannel, int *pChanList, UINT nScanFreq,
								   USHORT nBufSizeGain, BOOL bPauseAtBufFull);
 EXTERN void	(*COMICX_US2_Resume) (HANDLE hDevice);
 EXTERN double	(*COMICX_US2_ChangeScanFreq) (HANDLE hDevice, UINT dwScanFreq);
 EXTERN ULONG	(*COMICX_US2_DmaCount) (HANDLE hDevice);
 EXTERN BOOL	(*COMICX_US2_IsBufFull) (HANDLE hDevice);
 EXTERN short*	(*COMICX_US2_GetBuffer) (HANDLE hDevice, int chOrder);
 EXTERN ULONG	(*COMICX_US2_RetrvChannel) (HANDLE hDevice, int chOrder, ULONG startCount,
						int maxNumData, void *pDestBuf, TComiVarType VarType);
 EXTERN void	(*COMICX_US2_Stop) (HANDLE hDevice, BOOL bReleaseBuf);
 EXTERN BOOL	(*COMICX_US2_ReleaseBuf) (HANDLE hDevice);
 //___________ DIO Common __________________________________________________//
 EXTERN void	(*COMICX_DIO_SetUsage) (HANDLE hDevice, int usage);
 EXTERN int		(*COMICX_DIO_GetUsage) (HANDLE hDevice);
 //__________ D/I Functions ________________________________________________//
 EXTERN int		(*COMICX_DI_GetOne) (HANDLE hDevice, int ch);
 EXTERN DWORD	(*COMICX_DI_GetAll) (HANDLE hDevice);
 EXTERN DWORD	(*COMICX_DI_GetAllEx) (HANDLE hDevice, int nGroupIdx);
 //__________ D/O Functions ________________________________________________//
 EXTERN void	(*COMICX_DO_PutOne) (HANDLE hDevice, int ch, int status);
 EXTERN void	(*COMICX_DO_PutAll) (HANDLE hDevice, DWORD dwStatuses);
 EXTERN void	(*COMICX_DO_PutAllEx) (HANDLE hDevice, int nGroupIdx, DWORD dwStatuses);
 EXTERN DWORD	(*COMICX_DO_GetOne) (HANDLE hDevice, int ch);
 EXTERN DWORD	(*COMICX_DO_GetAll) (HANDLE hDevice);
 EXTERN DWORD	(*COMICX_DO_GetAllEx) (HANDLE hDevice, int nGroupIdx);
 //__________ Serial Digital In/Out Functions ________________________________________________//
 EXTERN BOOL	(*COMICX_SDIO_InitComm) (HANDLE hDevice);
 EXTERN BOOL	(*COMICX_SDIO_CheckModule) (HANDLE hDevice, int nModuleNo);
 EXTERN BOOL	(*COMICX_SDIO_SetDioUsage) (HANDLE hDevice, int nModuleNo, int nUsge);
 EXTERN BYTE	(*COMICX_SDIO_ReadLowByte) (HANDLE hDevice, int nModuleNo);
 EXTERN BYTE	(*COMICX_SDIO_ReadHighByte) (HANDLE hDevice, int nModuleNo);
 EXTERN BOOL	(*COMICX_SDIO_WriteLowByte) (HANDLE hDevice, int nModuleNo, BYTE bValue);
 EXTERN BOOL	(*COMICX_SDIO_WriteHighByte) (HANDLE hDevice, int nModuleNo, BYTE bValue);
 //__________ D/A Functions ________________________________________________//
 EXTERN void	(*COMICX_DA_SetRange) (HANDLE hDevice, int ch, int VMin, int VMax);
 EXTERN BOOL	(*COMICX_DA_Out) (HANDLE hDevice, int ch, float volt);
 EXTERN long	(*COMICX_WFM_Start) (HANDLE hDevice, int ch, float *pDataBuffer, 
						UINT nNumData, double fPPS, int nMaxLoops);
 EXTERN BOOL	(*COMICX_WFM_Reload) (HANDLE hDevice, int ch, float *pDataBuffer, UINT nNumData);
 EXTERN long	(*COMICX_WFM_RateChange) (HANDLE hDevice, int ch, double fPPS);
 EXTERN long	(*COMICX_WFM_GetCurPos) (HANDLE hDevice, int ch);
 EXTERN long	(*COMICX_WFM_GetCurLoops) (HANDLE hDevice, int ch);
 EXTERN void	(*COMICX_WFM_Stop) (HANDLE hDevice, int ch);
 //__________ Counter Functions ____________________________________________//
 EXTERN ULONG 	(*COMICX_ReadCounter32) (HANDLE hDevice, int ch);
 EXTERN void 	(*COMICX_ClearCounter32) (HANDLE hDevice, int ch);
 //__________ ST501 Functions ______________________________________________//
 EXTERN void	(*COMICX_ENC_Config) (HANDLE hDevice, int ch, int mode, BOOL bResetByZ);
 EXTERN void	(*COMICX_ENC_Reset) (HANDLE hDevice, int ch);
 EXTERN void	(*COMICX_ENC_Load) (HANDLE hDevice, int ch, long Count);
 EXTERN long	(*COMICX_ENC_Read) (HANDLE hDevice, int ch);
 EXTERN void	(*COMICX_ENC_ResetZ) (HANDLE hDevice, int ch);
 EXTERN void	(*COMICX_ENC_LoadZ) (HANDLE hDevice, int ch, short count);
 EXTERN short	(*COMICX_ENC_ReadZ) (HANDLE hDevice, int ch);
 EXTERN double	(*COMICX_PG_Start) (HANDLE hDevice, int ch, double freq, UINT num_pulses);
 EXTERN double	(*COMICX_PG_ChangeFreq) (HANDLE hDevice, int ch, double freq);
 EXTERN BOOL	(*COMICX_PG_IsActive) (HANDLE hDevice, int ch);
 EXTERN void	(*COMICX_PG_Stop) (HANDLE hDevice, int ch);
 //__________ ST501S Functions ______________________________________________//
 EXTERN long	(*COMICX_501S_ReadUpDownCount) (HANDLE hDevice, int ch);
 EXTERN void	(*COMICX_501S_LoadUpDownCount) (HANDLE hDevice, int ch, long nCount);
 EXTERN void	(*COMICX_501S_ClearFcCount) (HANDLE hDevice, int ch);
 EXTERN long	(*COMICX_501S_ReadFcCount) (HANDLE hDevice, int ch);
 EXTERN void	(*COMICX_501S_SelectFcBClk) (HANDLE hDevice, int ch, int nClkIdx);
 EXTERN double	(*COMICX_501S_GetFcBClk) (HANDLE hDevice, int ch);

 //__________ Motion/Control Functions ____________________________________________//
 // Initialize functions //
 EXTERN void (*COMICX_MC_Reset) (HANDLE hDevice);
 EXTERN void (*COMICX_MC_ServoOn) (HANDLE hDevice, int nChannel, BOOL bEnable);
 EXTERN int	 (*COMICX_MC_GetServoOn) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_SetBlockingMode) (HANDLE hDevice, BOOL bBlocking);
 EXTERN void (*COMICX_MC_SetWindowHandle) (HANDLE hDevice, ULONG hWnd);
 EXTERN void (*COMICX_MC_SetOutputMode) (HANDLE hDevice, int nChannel, int nOutputMode);
 EXTERN int	 (*COMICX_MC_GetOutputMode) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_SetInputMode) (HANDLE hDevice, int nChannel, int nInputMode, int nPulseLogic);
 EXTERN void (*COMICX_MC_GetInputMode) (HANDLE hDevice, int nChannel, int *pInputMode, int *pPulseLogic);
 EXTERN void (*COMICX_MC_SetSpeedRange) (HANDLE hDevice, int nChannel, double fMaxSpeed);
 EXTERN void (*COMICX_MC_GetSpeedRange) (HANDLE hDevice, int nChannel, double *fMinSpeed, double *fMaxSpeed);
 EXTERN void (*COMICX_MC_SetUnitDistance) (HANDLE hDevice, int nChannel, double fUnitDist);
 EXTERN double (*COMICX_MC_GetUnitDistance) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_SetUnitSpeed) (HANDLE hDevice, int nChannel, double fUnitSpeed);
 EXTERN double (*COMICX_MC_GetUnitSpeed) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_SetInOutRatio) (HANDLE hDevice, int nChannel, double fRatio);
 EXTERN void (*COMICX_MC_SetPosSrc) (HANDLE hDevice, int nChannel, int nSource);
 // Single Axis Motions //
 EXTERN void (*COMICX_MC_SetSpeedMode) (HANDLE hDevice, int nChannel, int nModeIndex);
 EXTERN void (*COMICX_MC_SetSpeed) (HANDLE hDevice, int nChannel, double fIniSpeed, double fWorkSpeed);
 EXTERN void (*COMICX_MC_SetAccel) (HANDLE hDevice, int nChannel, double fAccel, double fDecel);
 EXTERN void (*COMICX_MC_SetScurve) (HANDLE hDevice, int nChannel, double fSVacc, double fSVdec);
 EXTERN void (*COMICX_MC_StartVMove) (HANDLE hDevice, int nChannel, int nDirection);
 EXTERN void (*COMICX_MC_StartMove) (HANDLE hDevice, int nChannel, double fDistance);
 EXTERN void (*COMICX_MC_Move) (HANDLE hDevice, int nChannel, double fDistance);
 EXTERN void (*COMICX_MC_StartMoveTo) (HANDLE hDevice, int nChannel, double fPosition);
 EXTERN void (*COMICX_MC_MoveTo) (HANDLE hDevice, int nChannel, double fPosition);
 EXTERN void (*COMICX_MC_Stop) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_EmgStop) (HANDLE hDevice, int nChannel);
 EXTERN BOOL (*COMICX_MC_Done) (HANDLE hDevice, int nChannel);
 // Multi-Axes Motion //
 EXTERN void (*COMICX_MC_StartVMoveAll) (HANDLE hDevice, int nNumAxis, int nAxisList[], int nDirList[]);
 EXTERN void (*COMICX_MC_StartMoveAll) (HANDLE hDevice, int nNumAxis, int nAxisList[], double fDistList[]);
 EXTERN void (*COMICX_MC_MoveAll) (HANDLE hDevice, int nNumAxis, int nAxisList[], double fDistList[]);
 EXTERN void (*COMICX_MC_StartMoveToAll) (HANDLE hDevice, int nNumAxis, int nAxisList[], double fPosList[]);
 EXTERN void (*COMICX_MC_MoveToAll) (HANDLE hDevice, int nNumAxis, int nAxisList[], double fPosList[]);
 EXTERN void (*COMICX_MC_StopAll) (HANDLE hDevice, int nNumAxis, int nAxisList[]);
 EXTERN void (*COMICX_MC_EmgStopAll) (HANDLE hDevice, int nNumAxis, int nAxisList[]);
 EXTERN BOOL (*COMICX_MC_AllDone) (HANDLE hDevice, int nNumAxis, int nAxisList[]);
 // Coordinated Motion //
 EXTERN BOOL (*COMICX_MC_MapAxes) (HANDLE hDevice, int nMapIndex, unsigned char bMapMask);
 EXTERN void (*COMICX_MC_SetSpeedModeMx) (HANDLE hDevice, int nMapIndex, int nModeIndex);
 EXTERN void (*COMICX_MC_SetSpeedMx) (HANDLE hDevice, int nMapIndex, double fSpeed, double fAccel);
 EXTERN void (*COMICX_MC_StartLine) (HANDLE hDevice, int nMapIndex, double fDistList[]);
 EXTERN void (*COMICX_MC_Line) (HANDLE hDevice, int nMapIndex, double fDistList[]);
 EXTERN void (*COMICX_MC_StartLineTo) (HANDLE hDevice, int nMapIndex, double fPosList[]);
 EXTERN void (*COMICX_MC_LineTo) (HANDLE hDevice, int nMapIndex, double fPosList[]);
 EXTERN void (*COMICX_MC_StartArc_a) (HANDLE hDevice, int nMapIndex, double fXCentOffset, double fYCentOffset, double fEndAngle);
 EXTERN void (*COMICX_MC_Arc_a) (HANDLE hDevice, int nMapIndex, double fXCentOffset, double fYCentOffset, double fEndAngle);
 EXTERN void (*COMICX_MC_StartArc_p) (HANDLE hDevice, int nMapIndex, double fXCentOffset, double fYCentOffset, double fXEndPointDist, double fYEndPointDist, int nDir);
 EXTERN void (*COMICX_MC_Arc_p) (HANDLE hDevice, int nMapIndex, double fXCentOffset, double fYCentOffset, double fXEndPointDist, double fYEndPointDist, int nDir);
 EXTERN void (*COMICX_MC_StartArcTo_a) (HANDLE hDevice, int nMapIndex, double fXCent, double fYCent, double fEndAngle);
 EXTERN void (*COMICX_MC_ArcTo_a) (HANDLE hDevice, int nMapIndex, double fXCent, double fYCent, double fEndAngle);
 EXTERN void (*COMICX_MC_StartArcTo_p) (HANDLE hDevice, int nMapIndex, double fXCent, double fYCent, double fXEndPos, double fYEndPos, int nDir);
 EXTERN void (*COMICX_MC_ArcTo_p) (HANDLE hDevice, int nMapIndex, double fXCent, double fYCent, double fXEndPos, double fYEndPos, int nDir);
 EXTERN void (*COMICX_MC_CompleteArc) (HANDLE hDevice, int nMapIndex);
 EXTERN BOOL (*COMICX_MC_MxDone) (HANDLE hDevice, int nMapIndex);
 // Spline Interpolation //
 EXTERN double* (*COMICX_MC_BuildSpline) (double fInPoints[], int nNumInPoints, int nNumOutPoints);
 EXTERN void (*COMICX_MC_DeleteSpline) (double *pSplineBuffer);
 // Helical Interpolation //
 EXTERN BOOL (*COMICX_MC_StartHelical) (HANDLE hDevice, THelicalUserInfo *pHelicalUserInfo);
 EXTERN BOOL (*COMICX_MC_AbortHelical) (HANDLE hDevice);

 // Overriding //
 EXTERN void (*COMICX_MC_OverrideSpeedSet) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_OverrideSpeedSetAll) (HANDLE hDevice, int nNumAxis, int nAxisList[]);
 EXTERN void (*COMICX_MC_OverrideMove) (HANDLE hDevice, int nChannel, double fNewDistance);
 EXTERN void (*COMICX_MC_OverrideMoveTo) (HANDLE hDevice, int nChannel, double fNewPosition);
 // Home Move //
 EXTERN void (*COMICX_MC_SetHomeConfig) (HANDLE hDevice, int nChannel, int nOrgMode, int nOrgLogic, int nEzCount, int nEzLogic, int nErcOut);
 EXTERN void (*COMICX_MC_HomeMove) (HANDLE hDevice, int nChannel, int nDirection, double fRvsVel);
 
 // External Switch Move //
 EXTERN void (*COMICX_MC_StartVMoveEx) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_StartMoveEx) (HANDLE hDevice, int nChannel, double fDistance);
 // Pulser Mode //
 EXTERN void (*COMICX_MC_SetPulserInputMode) (HANDLE hDevice, int nChannel, int nInputMode, BOOL bInverse);
 EXTERN void (*COMICX_MC_PulserHomeMove) (HANDLE hDevice, int nChannel, int nHomeType);
 EXTERN void (*COMICX_MC_StartPulserVMove) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_StartPulserMove) (HANDLE hDevice, int nChannel, double fDistance);
 EXTERN void (*COMICX_MC_PulserMove) (HANDLE hDevice, int nChannel, double fDistance);
 EXTERN void (*COMICX_MC_StartPulserMoveTo) (HANDLE hDevice, int nChannel, double fPosition);
 EXTERN void (*COMICX_MC_PulserMoveTo) (HANDLE hDevice, int nChannel, double fPosition);
 // List-Motion //
 EXTERN void (*COMICX_MC_SetListMotionAxes) (HANDLE hDevice, unsigned char bMapMask);
 EXTERN void (*COMICX_MC_BeginList) (HANDLE hDevice);
 EXTERN void (*COMICX_MC_EndList) (HANDLE hDevice);
 EXTERN void (*COMICX_MC_StartListMotion) (HANDLE hDevice);
 EXTERN void (*COMICX_MC_AbortListMotion) (HANDLE hDevice);
 EXTERN BOOL (*COMICX_MC_CheckListMotionDone) (HANDLE hDevice);
 // Reset //
 EXTERN void (*COMICX_MC_ResetAxis) (HANDLE hDevice, int nChannel);
 // Get/Set Status //
 EXTERN double (*COMICX_MC_GetCurSpeed) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_EnableActSpdChk) (HANDLE hDevice, long dwInterval);
 EXTERN void (*COMICX_MC_DisableActSpdChk) (HANDLE hDevice);
 EXTERN double (*COMICX_MC_GetActualSpeed) (HANDLE hDevice, int nChannel);
 EXTERN double (*COMICX_MC_GetPosition_A) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_SetPosition_A) (HANDLE hDevice, int nChannel, double fActualPos);
 EXTERN double (*COMICX_MC_GetPosition_C) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_SetPosition_C) (HANDLE hDevice, int nChannel, double fPosition);
 EXTERN long (*COMICX_MC_GetCount_A) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_SetCount_A) (HANDLE hDevice, int nChannel, long nCount);
 EXTERN long (*COMICX_MC_GetCount_C) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_SetCount_C) (HANDLE hDevice, int nChannel, long nCount);
 EXTERN long (*COMICX_MC_GetCount_D) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_SetCount_D) (HANDLE hDevice, int nChannel, long nCount);
 EXTERN long (*COMICX_MC_GetCount_G) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_SetCount_G) (HANDLE hDevice, int nChannel, long nCount);
 EXTERN long (*COMICX_MC_GetCount_R) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_SetCount_R) (HANDLE hDevice, int nChannel, long nCount);
 EXTERN long (*COMICX_MC_ReadLatchCounter) (HANDLE hDevice, int nChannel, int nCounter);
 EXTERN BOOL (*COMICX_MC_GetLatchState) (HANDLE hDevice, int nChannel);
 EXTERN int (*COMICX_MC_GetMotionStatus) (HANDLE hDevice, int nChannel);
 EXTERN int (*COMICX_MC_GetMioStatus) (HANDLE hDevice, int nChannel);
 // Set Config //
 EXTERN void (*COMICX_MC_SetFilterLogic) (HANDLE hDevice, int nChannel, BOOL bEnable);
 EXTERN void (*COMICX_MC_SetPE) (HANDLE hDevice, int nChannel, BOOL bEnable);
 EXTERN void (*COMICX_MC_SetELL) (HANDLE hDevice, int nChannel, int nLogic);
 EXTERN void (*COMICX_MC_SetMioCfgALM) (HANDLE hDevice, int nChannel, int nAlarmLogic, int nAlarmMode);
 EXTERN void (*COMICX_MC_GetMioCfgALM) (HANDLE hDevice, int nChannel, int *pAlarmLogic, int *pAlarmMode);
 EXTERN void (*COMICX_MC_SetMioCfgCLR) (HANDLE hDevice, int nChannel, int CntrSel, int nSignalType);
 EXTERN void (*COMICX_MC_GetMioCfgCLR) (HANDLE hDevice, int nChannel, int *pCntrSel, int *pnSignalType);
 EXTERN void (*COMICX_MC_SetMioCfgCMP) (HANDLE hDevice, int nChannel, ULONG nCmpPulseWidth, int nCmpLogic);
 EXTERN void (*COMICX_MC_GetMioCfgCMP) (HANDLE hDevice, int nChannel, ULONG *pnCmpPulseWidth, int *pnCmpLogic);
 EXTERN void (*COMICX_MC_SetMioCfgDR) (HANDLE hDevice, int nChannel, int nLogic);
 EXTERN void (*COMICX_MC_GetMioCfgDR) (HANDLE hDevice, int nChannel, int *pnLogic);
 EXTERN void (*COMICX_MC_SetMioCfgEL) (HANDLE hDevice, int nChannel, int nElMode);
 EXTERN void (*COMICX_MC_GetMioCfgEL) (HANDLE hDevice, int nChannel, int *pElMode);
 EXTERN void (*COMICX_MC_SetMioCfgERC) (HANDLE hDevice, int nChannel, int nErcLogic, int nErcOnTime);
 EXTERN void (*COMICX_MC_GetMioCfgERC) (HANDLE hDevice, int nChannel, int *pErcLogic, int *pErcOnTime);
 EXTERN void (*COMICX_MC_SetMioCfgLTC) (HANDLE hDevice, int nChannel, int nLtcLogic, int nLtc2Src);
 EXTERN void (*COMICX_MC_GetMioCfgLTC) (HANDLE hDevice, int nChannel, int *pnLtcLogic, int *pnLtc2Src);
 EXTERN void (*COMICX_MC_SetMioCfgINP) (HANDLE hDevice, int nChannel, BOOL bInpEnable, int nInpLogic);
 EXTERN void (*COMICX_MC_GetMioCfgINP) (HANDLE hDevice, int nChannel, BOOL *pInpEnable, int *pInpLogic);
 EXTERN void (*COMICX_MC_SetMioCfgSD) (HANDLE hDevice, int nChannel, BOOL bSdEnable, int nSdLogic, int nSdLatch, int nSdMode);
 EXTERN void (*COMICX_MC_GetMioCfgSD) (HANDLE hDevice, int nChannel, BOOL *pSdEnable, int *pSdLogic, int *pSdLatch, int *pSdMode);
 EXTERN void (*COMICX_MC_SetMioCfgSTA) (HANDLE hDevice, int nChannel, int nMode, int nInputType);
 EXTERN void (*COMICX_MC_SetMioCfgSTP) (HANDLE hDevice, int nChannel, int nMode);
 EXTERN void (*COMICX_MC_SetSoftLimit) (HANDLE hDevice, int nChannel, double fLimitP, double fLimitN);
 EXTERN void (*COMICX_MC_EnableSoftLimit) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_DisableSoftLimit) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_SetErrorCompare) (HANDLE hDevice, int nChannel, double fTol, int bEnable);
 EXTERN void (*COMICX_MC_SetGeneralCompare) (HANDLE hDevice, int nChannel, int nCmpSrc, int nCmpMethod, int nCmpAction, double fData);
 EXTERN void (*COMICX_MC_SetTriggerCompare) (HANDLE hDevice, int nChannel, int nCmpSrc, 
				int nCmpMethod, double fData);
 EXTERN BOOL (*COMICX_MC_RegTableCCMP) (HANDLE hDevice, int nChannel, double *pDataBuffer, int nNumData);
 EXTERN BOOL (*COMICX_MC_BuildTableCCMP) (HANDLE hDevice, int nChannel, double fStartData, double fInterval, int nNumData);
 EXTERN BOOL (*COMICX_MC_StartCCMP) (HANDLE hDevice, int nChannel, int nCmpSrc, int nCmpMethod);
 EXTERN BOOL (*COMICX_MC_StopCCMP) (HANDLE hDevice, int nChannel);

 // Interrupt //
 EXTERN void (*COMICX_MC_MaskInterrupt) (HANDLE hDevice, int nChannel, long dwMask);
 EXTERN void (*COMICX_MC_EnableInterrupt) (HANDLE hDevice, HANDLE hEvent);
 EXTERN void (*COMICX_MC_DisableInterrupt) (HANDLE hDevice);
 EXTERN BOOL (*COMICX_MC_GetAxisIntState) (HANDLE hDevice, int nChannel);
 EXTERN void (*COMICX_MC_GetIntStatus) (HANDLE hDevice, int nChannel, long *pErrorStatus, long *pEventStatus);

 // New Added Functions (V3.1.0.0) //
 EXTERN void (*COMICX_MC_SetSpeedMx2) (HANDLE hDevice, int nMapIndex, double fSpeed, double fAccel, double fDecel);
 EXTERN void (*COMICX_MC_PutIntSTA) (HANDLE hDevice, int ChanMask);
 EXTERN void (*COMICX_MC_SetSyncMode) (HANDLE hDevice, int nChannel, int nMode, int nRefChan, int nCond);
 EXTERN void (*COMICX_MC_HomeMoveAuto) (HANDLE hDevice, int nChannel, int nDirection, 
									  double fRvsVel, double fEscapeDist);
 EXTERN void (*COMICX_MC_HomeMoveAutoAll) (HANDLE hDevice, int nNumAxis, int nAxisList[], int nDirList[],
									double fRvsVelList[], double fEscapeDistList[]);
 EXTERN void (*COMICX_MC_SetHelOnceSpeed) (HANDLE hDevice, int nMaster, int nSpeedMode, double fSpeed, 
											double fAcc, double fDec);
 EXTERN double	(*COMICX_MC_StartHelOnce) (HANDLE hDevice, int nNumAxis, int nAxisList[], double fCoordList[], double fArcAngle);
 EXTERN double	(*COMICX_MC_HelOnce) (HANDLE hDevice, int nNumAxis, int nAxisList[], double fCoordList[], double fArcAngle);
 EXTERN int		(*COMICX_MC_LmCurSequence) (HANDLE hDevice);
 EXTERN void	(*COMICX_MC_LmSetImmediacy) (HANDLE hDevice);
 EXTERN void	(*COMICX_MC_GetHomeConfig) (HANDLE hDevice, int nChannel, int *pnOrgMode, int *pnOrgLogic, int *pnEzCount, int *pnEzLogic, int *pnErcOut);
 EXTERN void	(*COMICX_MC_GetFilterLogic) (HANDLE hDevice, int nChannel, int *pbEnable);
 EXTERN void	(*COMICX_MC_GetPE) (HANDLE hDevice, int nChannel, int *pbEnable);
 EXTERN void	(*COMICX_MC_GetELL) (HANDLE hDevice, int nChannel, int *pnLogic);;
 EXTERN void	(*COMICX_MC_SetOutputMask) (HANDLE hDevice, int nChannel, BOOL bMask);
 EXTERN BOOL	(*COMICX_MC_GetOutputMask) (HANDLE hDevice, int nChannel);
 EXTERN int		(*COMICX_MC_InitFromFile) (HANDLE hDevice, char *szFilePath);
 EXTERN double	(*COMICX_MC_GetInOutRatio) (HANDLE hDevice, int nChannel);
 EXTERN void	(*COMICX_MC_GetMioCfgSTA) (HANDLE hDevice, int nChannel, int *pnMode, int *pnInputType);
 EXTERN void	(*COMICX_MC_GetMioCfgSTP) (HANDLE hDevice, int nChannel, int *pnMode);
 EXTERN void	(*COMICX_MC_GetSoftLimit) (HANDLE hDevice, int nChannel, double *pfLimitP, double *pfLimitN);
 EXTERN BOOL	(*COMICX_MC_GetEnableSoftLimit) (HANDLE hDevice, int nChannel);
 EXTERN void	(*COMICX_MC_GetDeviceVer) (HANDLE hDevice, int *pnVerMajor, int *pnVerMinor);
 EXTERN int		(*COMICX_EnableDebugLog) (HANDLE hDevice, char *szLogFile, int nDebugLevel);
 EXTERN void	(*COMICX_MC_ReadAllRegs) (HANDLE hDevice, ULONG lRegArray[][60]);
 
 //__________ Utility Functions ____________________________________________//
 EXTERN int		(*COMICX_LastError) (void);
 EXTERN const char* (*COMICX_ErrorString) (int nErrCode);
 EXTERN BOOL	(*COMICX_GetAvailDevList) (TComiDevList *pDevList);
 EXTERN BOOL	(*COMICX_GetDevInfo) (HANDLE hDevice, TComiDevInfo *pDevInfo);
 EXTERN void 	(*COMICX_GetResources) (HANDLE hDevice, PULONG pdwIntVect, PULONG pdwIoPorts,
					 int nNumPorts, PULONG pdwMemPorts, int nNumMemPorts);
 EXTERN void	(*COMICX_WriteMemPortDW) (HANDLE hDevice, ULONG dwPortBase, ULONG nOffset, DWORD dwOutVal);
 EXTERN DWORD	(*COMICX_ReadMemPortDW) (HANDLE hDevice, ULONG dwPortBase, ULONG nOffset);
 EXTERN void	(*COMICX_Write8402) (HANDLE hDevice, int ch, int addr, int data);
 EXTERN void	(*COMICX_WriteEEPR) (HANDLE hDevice, int addr, int data);
 EXTERN int		(*COMICX_ReadEEPR) (HANDLE hDevice, int addr);

#undef EXTERN
#endif

#ifdef __cplusplus
}
#endif

#endif
